package com.agilex.healthcare.veteranappointment.domain;

import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.*;

@JsonAutoDetect
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class VARAppointmentRequests extends VARPatientDataCollection<VARAppointmentRequest> {
	private static final long serialVersionUID = -1232048559610824265L;

	private Date lastAccessDate;

	@JsonCreator
	public VARAppointmentRequests(){
		super();
	}

	@JsonProperty("appointmentRequests")
	public Iterator<VARAppointmentRequest> getAppointmentRequests() {
		return iterator();
	}

	public void setAppointmentRequests(Collection<VARAppointmentRequest> items){
		addAll(items);
	}

	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	public Date getLastAccessDate() {
		return lastAccessDate;
	}
	
	public void setLastAccessDate(Date lastAccessDate) {
		this.lastAccessDate = lastAccessDate;
	}
}
